/*************************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2001-2004.
-------------------------------------------------------------------------
$Id: AnimActionEditorBrowserPanel.cpp,v 1.1 2008/11/17 14:21:40 PauloZaffari Exp wwwrun $
$DateTime$
Description:  This is the source file for the module AnimactionEditorBrowserPanel. 
The AnimactionEditorBrowserPanel is a panel containing a XTP taskbar for the 
common Browser over the AnimAction editor.
-------------------------------------------------------------------------
History:
- 17:11:2008   14:21 : Created by Paulo Zaffari
*************************************************************************/

#include "stdafx.h"

#include "Dialogs\Generic\StringInputDialog.h"
#include "Dialogs\Generic\TreeElementSelectionDialog.h"

#include "AnimActionEditorBrowserPanel.h"
#include "Controls\AnimActionFileViewer.h"
#include "Support\EditorAnimActionManager.h"
#include "AnimActionEditorDialog.h"
#include "NewAnimActionDialog.h"
#include "Dialogs/Generic/GenericOverwriteDialog.h"

#include "IAnimAction.h"
#include "ICryAnimation.h"
#include "CharacterEditor\ModelViewportCE.h"

#include "CharacterEditor\Animationbrowser.h"

BEGIN_MESSAGE_MAP(CAnimActionEditorBrowserPanel, CXTResizeDialog)
	ON_WM_CLOSE()
	ON_WM_SIZE()
	ON_MESSAGE(	XTPWM_TASKPANEL_NOTIFY,&CAnimActionEditorBrowserPanel::OnTaskPanelNotify)
	ON_NOTIFY(TVN_SELCHANGED,eAnimActionViewerId,&CAnimActionEditorBrowserPanel::OnSelChanged)
	ON_NOTIFY(NM_RCLICK,eAnimActionViewerId,&CAnimActionEditorBrowserPanel::OnAnimActionTreeRightClick)
END_MESSAGE_MAP()

//////////////////////////////////////////////////////////////////////////
CAnimActionEditorBrowserPanel::CAnimActionEditorBrowserPanel(CWnd* pParent)
:CXTResizeDialog(CAnimActionEditorBrowserPanel::IDD, pParent),
m_poAnimActionViewer(NULL),
m_poAnimActionEditorDialog(NULL),
m_piCurrentAction(NULL),
m_strBaseDirectory(".\\Game\\Animations\\human\\male\\AnimActions\\")
{
	m_font.CreateFont( 14, 0, 0, 0,
		FW_NORMAL, FALSE, FALSE, FALSE,
		ANSI_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS, DEFAULT_QUALITY, 
		DEFAULT_PITCH, "Arial");

	Create( IDD,pParent );
}
//////////////////////////////////////////////////////////////////////////
CAnimActionEditorBrowserPanel::~CAnimActionEditorBrowserPanel()
{
	m_font.DeleteObject();
	SAFE_DELETE(m_poAnimActionViewer);
}
//////////////////////////////////////////////////////////////////////////
void CAnimActionEditorBrowserPanel::SetAnimActionEditorDialog(CAnimActionEditorDialog* poAnimActionEditorDialog)
{
	m_poAnimActionEditorDialog=poAnimActionEditorDialog;
}
//////////////////////////////////////////////////////////////////////////
bool CAnimActionEditorBrowserPanel::CreateFolder(HTREEITEM hParentItem,TDTreeItemContainer& chSelectedFolders,TDParentToPrototypeItems& cParentToPrototypeItems)
{
	BOOL																									bnOperationResult(FALSE);

	string																								strNewDirectoryName(m_strBaseDirectory);
	string																								strNewFolderName;
	CAnimActionFileViewer::TDDirectoryQueue								cstrDirectoryQueue;

	size_t																								nTotalFolderQueueSize(0);
	size_t																								nCurrentFolderQueueElement(0);
	DWORD																									nErrorValue(0);

	TDTreeItemContainer																		cItemContainer;

	CStringInputDialog																		oStringInputDialog("New Folder","Please, enter the name for the folder");

	// If we have a folder selected, we will create the new folder under the selected folder.
	// If we don't have a folder selected, then we will create under the common parent folder of
	// the selected items.
	if (chSelectedFolders.size()==1)
	{
		hParentItem=chSelectedFolders.front();
		m_poAnimActionViewer->GetDirectoryQueueFromTreeItem(hParentItem,cstrDirectoryQueue);
	}
	else if (m_chSelectedItems.size()>0)
	{
		hParentItem=cParentToPrototypeItems.begin()->first;
		m_poAnimActionViewer->GetDirectoryQueueFromTreeItem(hParentItem,cstrDirectoryQueue);
	}
	else
	{
		// No queue needed :-)
		hParentItem=NULL;
	}

	nTotalFolderQueueSize=cstrDirectoryQueue.size();
	for (nCurrentFolderQueueElement=0;nCurrentFolderQueueElement<nTotalFolderQueueSize;++nCurrentFolderQueueElement)
	{
		strNewDirectoryName+=cstrDirectoryQueue[nCurrentFolderQueueElement];
		strNewDirectoryName+="\\";
	}

	INT_PTR res = oStringInputDialog.DoModal();
	if( res==IDOK )
	{
		strNewFolderName=oStringInputDialog.GetResultingText();
		strNewDirectoryName+=strNewFolderName;
	}
	else
	{
		return true;
	}

	m_poAnimActionViewer->FindItem(cItemContainer,strNewFolderName,hParentItem);
	// Here we already have found an item. We can't add a new one with the same name.
	if (!cItemContainer.empty())
	{
		return false;
	}

	// We should consider changing CreateDirectory to CFileUtil::CreateDirectory() .
	bnOperationResult=CreateDirectory(strNewDirectoryName.c_str(),NULL);
	// If the folder could not be created, then we will not add it to the interface...
	if (!bnOperationResult)
	{
		nErrorValue=GetLastError();
		if (nErrorValue!=ERROR_ALREADY_EXISTS)
		{
			m_chSelectedItems.clear();
			return false;
		}
		else
		{
			m_poAnimActionViewer->CreateFolder((CString)strNewFolderName.c_str(),hParentItem);
		}
	}
	else
	{
		m_poAnimActionViewer->CreateFolder((CString)strNewFolderName.c_str(),hParentItem);
	}

	m_chSelectedItems.clear();

	return true;
}
//////////////////////////////////////////////////////////////////////////
bool CAnimActionEditorBrowserPanel::RemoveFolder(TDTreeItemContainer& chSelectedFolders)
{
	string																								strNewDirectoryName;

	size_t																								nTotalNumberOfSelectedFolders(0);
	size_t																								nCurrentSelectedFolders(0);

	CAnimActionFileViewer::TDDirectoryQueue								cstrDirectoryQueue;
	size_t																								nTotalFolderQueueSize(0);
	size_t																								nCurrentFolderQueueElement(0);

	bool																									boDeletedTree(false);
	HTREEITEM																							hCurrentItem(NULL);

	CAnimActionFileViewer::TDItemContainer								cChildPrototypes;
	size_t																								nTotalNumberOfPrototypes(0);
	size_t																								nCurrentPrototype(0);
	IAnimActionClass*																			piPrototype(NULL);
	HTREEITEM																							hCurrentPrototype(NULL);

	nTotalNumberOfSelectedFolders=chSelectedFolders.size();
	for (nCurrentSelectedFolders=0;nCurrentSelectedFolders<nTotalNumberOfSelectedFolders;++nCurrentSelectedFolders)
	{
		strNewDirectoryName=m_strBaseDirectory;
		hCurrentItem=chSelectedFolders[nCurrentSelectedFolders];
		m_poAnimActionViewer->GetDirectoryQueueFromTreeItem(hCurrentItem,cstrDirectoryQueue);
		nTotalFolderQueueSize=cstrDirectoryQueue.size();
		for (nCurrentFolderQueueElement=0;nCurrentFolderQueueElement<nTotalFolderQueueSize;++nCurrentFolderQueueElement)
		{
			strNewDirectoryName+=cstrDirectoryQueue[nCurrentFolderQueueElement];
			strNewDirectoryName+="\\";
		}

		// We must delete all the contents of the directory before removing it.
		boDeletedTree=CFileUtil::Deltree(strNewDirectoryName.c_str(),true);

		//Should we do something if we fail to delete the directory?
		// Still, if the directory was deleted, we will remove it from the interface.
		if (boDeletedTree)
		{
			m_poAnimActionViewer->FindAllChildPrototypes(cChildPrototypes,hCurrentItem,true);

			nTotalNumberOfPrototypes=cChildPrototypes.size();
			for (nCurrentPrototype=0;nCurrentPrototype<nTotalNumberOfPrototypes;++nCurrentPrototype)
			{
				hCurrentPrototype=cChildPrototypes[nCurrentPrototype];
				piPrototype=(IAnimActionClass*)m_poAnimActionViewer->GetItemData(hCurrentPrototype);
				CEditorAnimActionManager::GetAnimActionManager().DeletePrototype(piPrototype);
			}

			m_poAnimActionViewer->DeleteItem(hCurrentItem);
		}
	}

	m_chSelectedItems.clear();

	return true;
}
//////////////////////////////////////////////////////////////////////////
bool CAnimActionEditorBrowserPanel::RenameFolder()
{
	HTREEITEM																							hCurrentItem(NULL);
	CAnimActionFileViewer::TDDirectoryQueue								cstrDirectoryQueue;

	string																								strItemName;
	string																								strSourceDirectory(m_strBaseDirectory);
	string																								strTargetDirectory;				

	size_t																								nTotalNumberOfSelectedFolders(0);
	size_t																								nCurrentSelectedFolders(0);

	int																										nRenameResult(0);

	m_poAnimActionViewer->GetDirectoryQueueFromTreeItem(hCurrentItem,cstrDirectoryQueue);

	nTotalNumberOfSelectedFolders=cstrDirectoryQueue.size();
	for (nCurrentSelectedFolders=0;nCurrentSelectedFolders<nTotalNumberOfSelectedFolders;++nCurrentSelectedFolders)
	{
		strSourceDirectory+=cstrDirectoryQueue[nCurrentSelectedFolders];
		strSourceDirectory+="\\";
	}
	strTargetDirectory=strSourceDirectory;

	hCurrentItem=m_chSelectedItems[0];
	strItemName=m_poAnimActionViewer->GetItemText(hCurrentItem);
	strSourceDirectory+=strItemName;

	CStringInputDialog	oStringInputDialog(strItemName.c_str(),"Please, enter the new folder name");
	INT_PTR res = oStringInputDialog.DoModal();
	if( res==IDOK )
	{
		// Changes the dialogs.
		strItemName=oStringInputDialog.GetResultingText();
		strTargetDirectory+=strItemName;

		if (!m_poAnimActionViewer->RenameFolder(hCurrentItem,strItemName))
		{
			MessageBox("Failed to rename folder. The folders should comply with the OS folder names.",
				"Warning",MB_OK|MB_ICONEXCLAMATION);
		}
		m_chSelectedItems.clear();
	}
	else
	{
		// Whatever.
	}

	return true;
}
//////////////////////////////////////////////////////////////////////////
bool CAnimActionEditorBrowserPanel::CopyFolder()
{
	HTREEITEM																							hCurrentItem(NULL);
	CAnimActionFileViewer::TDDirectoryQueue								cstrDirectoryQueue;

	string																								strItemName;
	string																								strSourceDirectory(m_strBaseDirectory);
	string																								strTargetDirectory;				

	size_t																								nTotalNumberOfSelectedFolders(0);
	size_t																								nCurrentSelectedFolders(0);

	int																										nRenameResult(0);

	m_poAnimActionViewer->GetDirectoryQueueFromTreeItem(hCurrentItem,cstrDirectoryQueue);

	nTotalNumberOfSelectedFolders=cstrDirectoryQueue.size();
	for (nCurrentSelectedFolders=0;nCurrentSelectedFolders<nTotalNumberOfSelectedFolders;++nCurrentSelectedFolders)
	{
		strSourceDirectory+=cstrDirectoryQueue[nCurrentSelectedFolders];
		strSourceDirectory+="\\";
	}
	strTargetDirectory=strSourceDirectory;

	hCurrentItem=m_chSelectedItems[0];
	strItemName=m_poAnimActionViewer->GetItemText(hCurrentItem);
	strSourceDirectory+=strItemName;

	CStringInputDialog	oStringInputDialog(strItemName.c_str(),"Please, enter the folder name for the copied folder");
	INT_PTR res = oStringInputDialog.DoModal();
	if( res==IDOK )
	{
		// Changes the dialogs.
		if (!m_poAnimActionViewer->Copy(hCurrentItem,oStringInputDialog.GetResultingText()))
		{
			MessageBox("Failed to copy folder. The folders should comply with the OS folder names.",
				"Warning",MB_OK|MB_ICONEXCLAMATION);
		}
		m_chSelectedItems.clear();
	}
	else
	{
		// Whatever.
	}

	return true;
}
//////////////////////////////////////////////////////////////////////////
bool CAnimActionEditorBrowserPanel::MoveFolder()
{
	CTreeElementSelectionDialog	oTreeDialog("Select target folder:");				

	oTreeDialog.SetFont(&m_font);
	oTreeDialog.SetImageList(&m_imageList);	

	oTreeDialog.SetInitCallback(functor(*this,&CAnimActionEditorBrowserPanel::TreeSelectionMoveFolderDialogInitCallback));
	oTreeDialog.SetOkCallback(functor(*this,&CAnimActionEditorBrowserPanel::TreeSelectionMoveFolderDialogOkCallback));

	// As we set the callbacks, we don't even need to check the result.
	INT_PTR res = oTreeDialog.DoModal();

	return true;
}
//////////////////////////////////////////////////////////////////////////
bool CAnimActionEditorBrowserPanel::CreateAnimAction(TDTreeItemContainer& chSelectedFolders)
{
	CNewAnimActionDialog					oNewAnimActionDialog;
	CEditorAnimActionManager&			roEditorAnimActionManager=CEditorAnimActionManager::GetAnimActionManager();
	int														nSelectedOption(0);
	IAnimActionClass*							piAnimActionClass(NULL);
	IAnimActionClass*							piNewAnimActionPrototype(NULL);
	CString												strNewAnimActionFilename;
	CString												strDirectoryString;
	CString												strDisplayName;
	CString												strFullAnimActionPath(m_strBaseDirectory);
	CString												strOverwriteQuery;
	string												strAnimActionName;
	HTREEITEM											hParentItem(NULL);

	if (chSelectedFolders.size()==1)
	{
		hParentItem=chSelectedFolders.front();				
	}
	else
	{
		hParentItem=TVI_ROOT;				
	}

	m_poAnimActionViewer->GetRelativeDirectoryStringFromTreeItem(hParentItem,strDirectoryString);


	nSelectedOption=oNewAnimActionDialog.DoModal();
	switch(nSelectedOption)
	{
		case IDOK:
		{
			piAnimActionClass=oNewAnimActionDialog.GetAnimActionClass();

			strNewAnimActionFilename=oNewAnimActionDialog.GetAnimActionFilename();
			strAnimActionName=strDirectoryString;
			strDisplayName=Path::GetFileName(strNewAnimActionFilename).GetBuffer();
			strAnimActionName+=strDisplayName;
			strAnimActionName+=".caa";

			strFullAnimActionPath+=strAnimActionName;
			if (CFileUtil::FileExists(strFullAnimActionPath))
			{
				strOverwriteQuery.Format("There is already a file with name \"%s\". Are you sure you want to overwrite this AnimAction?",strAnimActionName.c_str());
				CGenericOverwriteDialog	oGenericOverwriteDialog("Confirm overwrite",strOverwriteQuery,false);

				switch (oGenericOverwriteDialog.DoModal())
				{
					case IDYES:
					{
						piNewAnimActionPrototype=roEditorAnimActionManager.CreateAnimActionPrototype(piAnimActionClass,strAnimActionName,strAnimActionName);
						m_poAnimActionViewer->CreatePrototype(strDisplayName,hParentItem,(DWORD_PTR)piNewAnimActionPrototype,TVI_FIRST,false);
					}
					break;

					case IDNO:
					{

					}
					break;

					case IDCANCEL:
					{

					}
					break;
				}				
			}
			m_chSelectedItems.clear();
		}
		break;

		case IDCANCEL:
		{
			// Nothing to be done here.
		}
		break;
	}

	m_chSelectedItems.clear();

	return true;
}
//////////////////////////////////////////////////////////////////////////
bool CAnimActionEditorBrowserPanel::RemoveAnimAction()
{
	size_t														nTotalNumberOfSelectedAnimActions(0);
	size_t														nCurrentNumberOfAnimActions(0);
	HTREEITEM													hCurrentItem(NULL);
	IAnimActionClass*									piSelectedAnimAction(NULL);

	CEditorAnimActionManager&					roAnimActionManager=CEditorAnimActionManager::GetAnimActionManager();

	// When deleting a prototype we have to delete it from the interface, from
	// the internal data structure AND from the file system.
	nTotalNumberOfSelectedAnimActions=m_chSelectedItems.size();
	for (nCurrentNumberOfAnimActions=0;nCurrentNumberOfAnimActions<nTotalNumberOfSelectedAnimActions;++nCurrentNumberOfAnimActions)
	{
		hCurrentItem=m_chSelectedItems[nCurrentNumberOfAnimActions];
		piSelectedAnimAction=(IAnimActionClass*)m_poAnimActionViewer->GetItemData(hCurrentItem);
		roAnimActionManager.DeletePrototype(piSelectedAnimAction);
		m_poAnimActionViewer->DeleteItem(hCurrentItem);
	}
	m_chSelectedItems.resize(0);

	return true;
}
//////////////////////////////////////////////////////////////////////////
bool CAnimActionEditorBrowserPanel::RenameAnimAction()
{
	size_t														nTotalNumberOfSelectedAnimActions(0);
	size_t														nCurrentNumberOfAnimActions(0);
	HTREEITEM													hCurrentItem(NULL);
	IAnimActionClass*									piSelectedAnimAction(NULL);

	CEditorAnimActionManager&					roAnimActionManager=CEditorAnimActionManager::GetAnimActionManager();

	CStringInputDialog								oStringInputDialog;
	int																nAcceptedNewFile(0);
	CString														strFilename;
	CString														strFullFilename;
	string														strOriginalFilename;

	oStringInputDialog.SetTitle("Rename AnimAction");

	// When deleting a prototype we have to delete it from the interface, from
	// the internal data structure AND from the file system.
	nTotalNumberOfSelectedAnimActions=m_chSelectedItems.size();
	for (nCurrentNumberOfAnimActions=0;nCurrentNumberOfAnimActions<nTotalNumberOfSelectedAnimActions;++nCurrentNumberOfAnimActions)
	{
		hCurrentItem=m_chSelectedItems[nCurrentNumberOfAnimActions];
		oStringInputDialog.SetText(m_poAnimActionViewer->GetItemText(hCurrentItem));

		nAcceptedNewFile=oStringInputDialog.DoModal();
		switch (nAcceptedNewFile)
		{
		case IDOK:
			{
				strFilename=oStringInputDialog.GetResultingText();
				strFilename=Path::GetFileName(strFilename);

				piSelectedAnimAction=(IAnimActionClass*)m_poAnimActionViewer->GetItemData(hCurrentItem);


				roAnimActionManager.GetAnimActionFilename(piSelectedAnimAction,strOriginalFilename);
				Path::ReplaceFilename(strOriginalFilename.c_str(),strFilename,strFullFilename);

				roAnimActionManager.RenamePrototype(piSelectedAnimAction,(string)strFullFilename.GetBuffer());
				m_poAnimActionViewer->SetItemText(hCurrentItem,strFilename);
			}
			break;

		default:
			{

			}
			break;
		}
	}
	m_chSelectedItems.resize(0);

	return true;
}
//////////////////////////////////////////////////////////////////////////
bool CAnimActionEditorBrowserPanel::CopyAnimAction()
{
	size_t														nTotalNumberOfSelectedAnimActions(0);
	size_t														nCurrentNumberOfAnimActions(0);
	HTREEITEM													hCurrentItem(NULL);
	IAnimActionClass*									piSelectedAnimAction(NULL);
	IAnimActionClass*									piNewAnimAction(NULL);

	CEditorAnimActionManager&					roAnimActionManager=CEditorAnimActionManager::GetAnimActionManager();

	CStringInputDialog								oStringInputDialog;
	int																nAcceptedNewFile(0);
	CString														strFilename;
	CString														strFullFilename;
	string														strOriginalFilename;

	oStringInputDialog.SetTitle("Copy AnimAction");

	hCurrentItem=m_chSelectedItems.front();
	oStringInputDialog.SetText(m_poAnimActionViewer->GetItemText(hCurrentItem));

	nAcceptedNewFile=oStringInputDialog.DoModal();
	switch (nAcceptedNewFile)
	{
	case IDOK:
		{
			strFilename=oStringInputDialog.GetResultingText();
			strFilename=Path::GetFileName(strFilename);

			piSelectedAnimAction=(IAnimActionClass*)m_poAnimActionViewer->GetItemData(hCurrentItem);

			roAnimActionManager.GetAnimActionFilename(piSelectedAnimAction,strOriginalFilename);
			Path::ReplaceFilename((CString)strOriginalFilename.c_str(),strFilename,strFullFilename);

			if (CFileUtil::CopyFile((CString)strOriginalFilename.c_str(),strFullFilename,true)!=CFileUtil::ETREECOPYOK)
			{
				m_chSelectedItems.clear();
				break;
			}

			piNewAnimAction=roAnimActionManager.LoadAnimAction((string)strFullFilename.GetBuffer());
			if (!piNewAnimAction)
			{
				break;
			}
			m_poAnimActionViewer->CreatePrototype(strFilename,m_poAnimActionViewer->GetParentItem(hCurrentItem),(DWORD_PTR)piNewAnimAction,hCurrentItem);

			m_chSelectedItems.clear();
		}
		break;

	default:
		{

		}
		break;
	}
	m_chSelectedItems.resize(0);

	return true;
}
//////////////////////////////////////////////////////////////////////////
bool CAnimActionEditorBrowserPanel::MoveAnimAction()
{
	CTreeElementSelectionDialog	oTreeDialog("Select target folder:");				

	oTreeDialog.SetFont(&m_font);
	oTreeDialog.SetImageList(&m_imageList);	

	oTreeDialog.SetInitCallback(functor(*this,&CAnimActionEditorBrowserPanel::TreeSelectionMoveAnimActionDialogInitCallback));
	oTreeDialog.SetOkCallback(functor(*this,&CAnimActionEditorBrowserPanel::TreeSelectionMoveAnimActionDialogOkCallback));

	// As we set the callbacks, we don't even need to check the result.
	INT_PTR res = oTreeDialog.DoModal();

	return true;
}
//////////////////////////////////////////////////////////////////////////
void CAnimActionEditorBrowserPanel::DoDataExchange(CDataExchange* pDX)
{
	CXTResizeDialog::DoDataExchange(pDX);
}
//////////////////////////////////////////////////////////////////////////
BOOL CAnimActionEditorBrowserPanel::OnInitDialog()
{
	BOOL bnReturnValue=__super::OnInitDialog();
	HTREEITEM						hFocuseedItem(NULL);

	CMFCUtils::LoadTrueColorImageList( m_imageList, IDB_ANIMATIONS_TREE, 16, RGB(255,0,255) );
	m_imageList.SetOverlayImage( 1,1 );

	m_poAnimActionViewer=new CAnimActionFileViewer();
	m_poAnimActionViewer->Create(this,CRect(0,0,100,100),WS_BORDER|WS_CHILD|WS_VISIBLE|TVS_HASLINES|TVS_LINESATROOT|TVS_EDITLABELS|TVS_TRACKSELECT|TVS_HASBUTTONS|TVS_SHOWSELALWAYS,eAnimActionViewerId);
	m_poAnimActionViewer->SetImageList( &m_imageList, TVSIL_NORMAL );
	m_poAnimActionViewer->SetFont( &m_font );
	m_poAnimActionViewer->SetRootDirectory(m_strBaseDirectory);

	hFocuseedItem=m_poAnimActionViewer->GetFirstVisibleItem();
	if (hFocuseedItem)
	{
		m_poAnimActionViewer->FocusItem(hFocuseedItem);
	}	

	return bnReturnValue;
}
//////////////////////////////////////////////////////////////////////////
void CAnimActionEditorBrowserPanel::OnClose()
{
	DestroyWindow();
}
//////////////////////////////////////////////////////////////////////////
void CAnimActionEditorBrowserPanel::OnSize(UINT nType,int cx,int cy)
{
	CRect		stRect;
	if (!m_poAnimActionViewer)
	{
		return;
	}

	GetClientRect(stRect);
	m_poAnimActionViewer->MoveWindow(stRect);
}
//////////////////////////////////////////////////////////////////////////
void CAnimActionEditorBrowserPanel::OnSelChanged(NMHDR* pNMHDR, LRESULT* pResult)
{
	HTREEITEM									hSelectedItem(NULL);
	CAnimActionEditorDialog::TDAnimActionPrototypes		cpiPrototypes;
	IAnimActionClass*					piCurrentPrototype(NULL);

	m_chSelectedItems.resize(0);

	hSelectedItem=m_poAnimActionViewer->GetFirstSelectedItem();

	while (hSelectedItem)
	{
		piCurrentPrototype=(IAnimActionClass*)m_poAnimActionViewer->GetItemData(hSelectedItem);
		if (piCurrentPrototype)
		{
			cpiPrototypes.push_back(piCurrentPrototype);
		}

		m_chSelectedItems.push_back(hSelectedItem);
		hSelectedItem=m_poAnimActionViewer->GetNextSelectedItem(hSelectedItem);
	}

	//// Add here a call to the CAnimAction(m_poParentComponent) object about this update so it will
	//// update the current properties considering the ones which are common to the whole selecion.
	if (m_poAnimActionEditorDialog)
	{		
		m_poAnimActionEditorDialog->OnNotifySelectionChange(cpiPrototypes);
	}
	

	// For now we are allowing default processing.
	*pResult=FALSE;
}
//////////////////////////////////////////////////////////////////////////
void CAnimActionEditorBrowserPanel::OnAnimActionTreeRightClick(NMHDR* pNMHDR, LRESULT* pResult)
{
	size_t													nTotalNumberOfSelectedItems(0);
	size_t													nCurrentSelectedItem(0);
	HTREEITEM												hParentItem(NULL);
	HTREEITEM												hNewItem(NULL);

	TDTreeItemContainer							chSelectedPrototypes;
	TDTreeItemContainer							chSelectedFolders;
	IAnimActionClass*								piAnimActionClass(NULL);

	CMenu														oPopupMenu;
	POINT														stMousePosition;
	int															nReturnedMenuOperation(0);

	TDParentToPrototypeItems				cParentToPrototypeItems;

	CEditorAnimActionManager&				roAnimActionManager=CEditorAnimActionManager::GetAnimActionManager();

	bool														boMultipleLevelsSelected(false);
	BOOL														bnOperationResult(FALSE);

	GetCursorPos(&stMousePosition);

	m_chFolderSet.clear();

	// We first sort all selected items...
	nTotalNumberOfSelectedItems=m_chSelectedItems.size();
	for (nCurrentSelectedItem=0;nCurrentSelectedItem<nTotalNumberOfSelectedItems;++nCurrentSelectedItem)
	{
		HTREEITEM	hCurrentItem(m_chSelectedItems[nCurrentSelectedItem]);
		piAnimActionClass=(IAnimActionClass*)m_poAnimActionViewer->GetItemData(hCurrentItem);

		hParentItem=m_poAnimActionViewer->GetParentItem(hCurrentItem);

		// Folder have item data set to NULL, so this way we can identify them.
		if (piAnimActionClass==NULL)
		{
			// Here we have a list of all folders.
			chSelectedFolders.push_back(hCurrentItem);
			m_chFolderSet.insert(hCurrentItem);
		}
		else
		{
			// Here we have all prototypes added to their list.
			chSelectedPrototypes.push_back(hCurrentItem);

			// And for every prototype, we have a multimap of parent item to the current prototype.
			cParentToPrototypeItems.insert(TDParentToPrototypeItems::value_type(hParentItem,hCurrentItem));
		}
	}

	// We have multiple levels selected if and only if we have either more than one folder selected OR
	// if we have prototypes of different parent items selected.
	if ((chSelectedFolders.size()>1))
	{
		boMultipleLevelsSelected=true;
	}

	// The number of the parent level selected is the number of categories in cParentToPrototypeItems.
	// Each category is the set of elements which have the same key.
	// If the size of the first category is different of the size of the entire container, then we have
	// at least 2 categories and thus at least 2 directories.
	if (cParentToPrototypeItems.size()>0)
	{
		if (cParentToPrototypeItems.count(cParentToPrototypeItems.begin()->first)!=cParentToPrototypeItems.size())
		{
			boMultipleLevelsSelected=true;
		}
	}

	oPopupMenu.CreatePopupMenu();

	// Create requires at most 1 folder to be selected.
	// If no folder is selected, you can still create a folder is ALL selected
	// items are on the same folder. If no selcted items, you can still create a folder in the root.
	if ((chSelectedFolders.size()<=1)||(chSelectedPrototypes.size()==0))
	{
		oPopupMenu.AppendMenu(MF_DISABLED ,-1,"FOLDER");
	}

	// We can have AT MOST one folder selected. If we have one selected, this will
	// be used as the parent folder. If none, we create the folder at the root.
	// We also can create a folder if ALL selected prototypes are from the same folder.
	if (chSelectedFolders.size()<=1)
	{
		oPopupMenu.AppendMenu(0,EMenuCreateFolder,"Create Folder");
	}	

	// Rename can ONLY be used if you have one single folder selected.
	if ((chSelectedFolders.size()==1)||(boMultipleLevelsSelected))
	{
		oPopupMenu.AppendMenu(0,EMenuRenameFolder,"Rename Folder");
	}

	// Remove folders requires at least one folder to be avialable.
	if ((chSelectedFolders.size()>=1)&&(chSelectedPrototypes.size()==0))
	{
		oPopupMenu.AppendMenu(0,EMenuCopyFolder,"Copy Folders");
		oPopupMenu.AppendMenu(0,EMenuMoveFolder,"Move Folders");
		oPopupMenu.AppendMenu(0,EMenuRemoveFolder,"Remove Folders");
	}
	

	oPopupMenu.AppendMenu(MF_SEPARATOR,-1,"");

	oPopupMenu.AppendMenu(MF_DISABLED ,-1,"ANIMACTION");

	oPopupMenu.AppendMenu(0,EMenuCreateAnimAction,"Create");

	if (chSelectedPrototypes.size()==1)
	{
		oPopupMenu.AppendMenu(0,EMenuRenameAnimAction,"Rename");
	}

	if (chSelectedPrototypes.size()>0)
	{
		oPopupMenu.AppendMenu(0,EMenuCopyAnimAction,"Copy");
		oPopupMenu.AppendMenu(0,EMenuRemoveAnimAction,"Delete");
		oPopupMenu.AppendMenu(0,EMenuMoveAnimAction,"Move");
	}

	if (chSelectedPrototypes.size()==1)
	{
		oPopupMenu.AppendMenu(0,EMenuPlayAnimAction,"Play");
	}

	nReturnedMenuOperation=oPopupMenu.TrackPopupMenu(TPM_LEFTALIGN|TPM_RETURNCMD,stMousePosition.x,stMousePosition.y,m_poAnimActionViewer);
	oPopupMenu.DestroyMenu();

	switch (nReturnedMenuOperation)
	{
		case EMenuCreateFolder:
			{
				CAnimActionEditorBrowserPanel::CreateFolder(hParentItem,chSelectedFolders,cParentToPrototypeItems);
			}
		break;

		case EMenuRemoveFolder:
			{
				CAnimActionEditorBrowserPanel::RemoveFolder(chSelectedFolders);
			}
		break;

		case EMenuRenameFolder:
			{
				CAnimActionEditorBrowserPanel::RenameFolder();
			}
		break;

		case EMenuCopyFolder:
			{
				CAnimActionEditorBrowserPanel::CopyFolder();
			}
		break;

		case EMenuMoveFolder:
			{
				CAnimActionEditorBrowserPanel::MoveFolder();
			}
		break;

		case EMenuCreateAnimAction:
		{
			CAnimActionEditorBrowserPanel::CreateAnimAction(chSelectedFolders);
		}
		break;

		case EMenuRemoveAnimAction:
		{
			CAnimActionEditorBrowserPanel::RemoveAnimAction();
		}
		break;

		case EMenuRenameAnimAction:
			{
				CAnimActionEditorBrowserPanel::RenameAnimAction();
			}
		break;

		case EMenuCopyAnimAction:
			{
				CAnimActionEditorBrowserPanel::CopyAnimAction();
			}
		break;

		case EMenuMoveAnimAction:
			{
				CAnimActionEditorBrowserPanel::MoveAnimAction();
			}
		break;

		case EMenuPlayAnimAction:
		{
			CAnimationBrowser* 	poAnimationPanel=CAnimationBrowser::GetCurrentInstance();
			ICharacterInstance*			piCurrentCharacter(NULL);
			if (!poAnimationPanel)
			{
				GetIEditor()->ExecuteCommand("Editor.Open_CharacterEditor");
			}
			poAnimationPanel=CAnimationBrowser::GetCurrentInstance();
			assert("Failed to get "&&poAnimationPanel);

			piCurrentCharacter= poAnimationPanel->GetModelViewportCE()->GetCharacterAnim();
			if (!piCurrentCharacter)
			{
				break;
			}
		

			if (chSelectedPrototypes.size()>0)
			{
				SAnimActionStartParams		stAnimAction;

				// We are play, currently, the animactions ALWAYS in layer 0.
				stAnimAction.m_nLayer=0;

				IAnimActionClass*		piAnimActionClass=(IAnimActionClass*)m_poAnimActionViewer->GetItemData(chSelectedPrototypes.front());
				IAnimActionActor*		piActor=piCurrentCharacter->GetIAnimActionActor();

				if (m_piCurrentAction)
				{
				//	m_piCurrentAction->Stop(true);
					//delete(m_piCurrentAction);
					//m_piCurrentAction=NULL;
				}

			//	m_piCurrentAction=piAnimActionClass->CreateAnimAction(piActor);
			//	m_piCurrentAction->Start(stAnimAction);
			}
		}
		break;
	}	

	// For now we are allowing default processing.
	*pResult=FALSE;
}
//////////////////////////////////////////////////////////////////////////
LRESULT CAnimActionEditorBrowserPanel::OnTaskPanelNotify( WPARAM wParam, LPARAM lParam )
{
	switch(wParam) 
	{
	case XTP_TPN_CLICK:
		{
			CXTPTaskPanelGroupItem* pItem = (CXTPTaskPanelGroupItem*)lParam;
			UINT nCmdID = pItem->GetID();
			//switch (nCmdID)
			//{
			//case eOpenFolderLink:
			//	{
			//		OnBnClickedTextureBrowserOpenFolderButton();
			//	}
			//	break;

			//case ePreviewLink:
			//	{
			//		OnBnClickedTextureBrowserPreviewButton();
			//	}
			//	break;
			//}
		}
	}
	return 0;
}
//////////////////////////////////////////////////////////////////////////
void CAnimActionEditorBrowserPanel::TreeSelectionMoveFolderDialogInitCallback(CTreeElementSelectionDialog* poSelectionDialog)
{
	HTREEITEM hRootItem(NULL);
	CTreeCtrl&	roTreeControl=poSelectionDialog->GetTreeControl();
	hRootItem=roTreeControl.InsertItem("",CAnimActionFileViewer::FOLDER_ICON,CAnimActionFileViewer::FOLDER_ICON);
	roTreeControl.SetItemData(hRootItem,NULL);
	m_poAnimActionViewer->CopyFolders(poSelectionDialog->GetTreeControl(),m_chFolderSet,TVI_ROOT,hRootItem);
}
//////////////////////////////////////////////////////////////////////////
void CAnimActionEditorBrowserPanel::TreeSelectionMoveFolderDialogOkCallback(CTreeElementSelectionDialog* poSelectionDialog)
{
	CTreeCtrl&																		roTreeControl=poSelectionDialog->GetTreeControl();
	HTREEITEM																			hSelectedItem(roTreeControl.GetSelectedItem());
	TDItemSet::iterator													itCurrentSelectedItem,itLastSelectedItem;

	string																				strTargetDirectory;

	HTREEITEM																			hSourceItem(NULL);
	string																				strSourceDirectory;

	HTREEITEM																			hTargetItemFolder(TVI_ROOT);

	// Maybe a deque would be a better option here.
	CAnimActionFileViewer::TDDirectoryQueue				cstrFolderStructure;

	CString																				strSelectedSourceDirectory;

	string																				strTemp;

	while (hSelectedItem!=NULL)
	{
		strTemp=roTreeControl.GetItemText(hSelectedItem).GetBuffer();
		if (strTemp.empty())
		{
			break;
		}
		strTargetDirectory.insert(0,"\\");
		strTargetDirectory.insert(0,strTemp);
		cstrFolderStructure.insert(cstrFolderStructure.begin(),strTemp);
		hSelectedItem=roTreeControl.GetParentItem(hSelectedItem);
	}
	strTargetDirectory.insert(0,m_strBaseDirectory);
		
	hTargetItemFolder=m_poAnimActionViewer->GetTreeItemFromDirectoryQueue(cstrFolderStructure);

	itLastSelectedItem=m_chFolderSet.end();
	for (itCurrentSelectedItem=m_chFolderSet.begin();itCurrentSelectedItem!=itLastSelectedItem;itCurrentSelectedItem++)
	{
		hSourceItem=*itCurrentSelectedItem;

		if (IsAnyParentFolderInFolderSet(hSourceItem,m_chFolderSet))
		{
			continue;
		}

		strSourceDirectory.resize(0,0);
		while (hSourceItem!=NULL)
		{
			strSourceDirectory.insert(0,"\\");
			strSourceDirectory.insert(0,m_poAnimActionViewer->GetItemText(hSourceItem));
			hSourceItem=m_poAnimActionViewer->GetParentItem(hSourceItem);
		}
		strSourceDirectory.insert(0,m_strBaseDirectory);

		CString		strTemporarySourceDirectory(strSourceDirectory);
		CString		strTemporaryTargetDirectory(strTargetDirectory);

		strTemporaryTargetDirectory+=m_poAnimActionViewer->GetItemText(*itCurrentSelectedItem);
		strTemporaryTargetDirectory+="\\";

		// This way we make sure that the path will be exist.
		CFileUtil::CreatePath(strTemporaryTargetDirectory);
		
		if (CFileUtil::MoveTree(strTemporarySourceDirectory,strTemporaryTargetDirectory,true,true)!=CFileUtil::ETREECOPYOK)
		{
			m_poAnimActionViewer->ReloadItems();
		}
		else
		{

			hTargetItemFolder=m_poAnimActionViewer->CreateFolder(m_poAnimActionViewer->GetItemText(*itCurrentSelectedItem),hTargetItemFolder);
			if (!m_poAnimActionViewer->MoveTreeSpecific(*m_poAnimActionViewer,*itCurrentSelectedItem,hTargetItemFolder))
			{
				m_poAnimActionViewer->ReloadItems();
			}
		}
	}

	m_chSelectedItems.clear();
}
//////////////////////////////////////////////////////////////////////////
bool CAnimActionEditorBrowserPanel::IsAnyParentFolderInFolderSet(HTREEITEM hItem,const TDItemSet& cSelectedFolder)
{
	HTREEITEM																			hParentItem(m_poAnimActionViewer->GetParentItem(hItem));

	while (hParentItem!=NULL)
	{
		if (cSelectedFolder.find(hParentItem)!=cSelectedFolder.end())
		{
			return true;
		}
		hParentItem=m_poAnimActionViewer->GetParentItem(hParentItem);
	}

	return false;
}
//////////////////////////////////////////////////////////////////////////
void CAnimActionEditorBrowserPanel::TreeSelectionMoveAnimActionDialogInitCallback(CTreeElementSelectionDialog* poSelectionDialog)
{
	HTREEITEM																hRootItem(NULL);
	CTreeCtrl&															roTreeControl=poSelectionDialog->GetTreeControl();

	CAnimActionFileViewer::TDItemSet				cItemContainer;

	cItemContainer.insert(TVI_ROOT);

	hRootItem=roTreeControl.InsertItem("",CAnimActionFileViewer::FOLDER_ICON,CAnimActionFileViewer::FOLDER_ICON);
	roTreeControl.SetItemData(hRootItem,NULL);
	m_poAnimActionViewer->CopyFolders(poSelectionDialog->GetTreeControl(),cItemContainer,TVI_ROOT,hRootItem);
}
//////////////////////////////////////////////////////////////////////////
void CAnimActionEditorBrowserPanel::TreeSelectionMoveAnimActionDialogOkCallback(CTreeElementSelectionDialog* poSelectionDialog)
{
	CTreeCtrl&																		roTreeControl=poSelectionDialog->GetTreeControl();
	HTREEITEM																			hSelectedItem(roTreeControl.GetSelectedItem());

	CEditorAnimActionManager&											roAnimActionManager=CEditorAnimActionManager::GetAnimActionManager();

	string																				strTargetDirectory;

	HTREEITEM																			hSourceItem(NULL);
	string																				strSourceFilePath;
	CString																				strTempSourceFilePath;

	HTREEITEM																			hTargetItemFolder(TVI_ROOT);

	// Maybe a deque would be a better option here.
	CAnimActionFileViewer::TDDirectoryQueue				cstrFolderStructure;

	string																				strTemp;

	IAnimActionClass*															piSelectedAnimAction(NULL);

	size_t																				nTotalNumberOfSelectedItems(0);
	size_t																				nCurrentSelectedItem(0);

	while (hSelectedItem!=NULL)
	{
		strTemp=roTreeControl.GetItemText(hSelectedItem).GetBuffer();
		if (strTemp.empty())
		{
			break;
		}
		strTargetDirectory.insert(0,"\\");
		strTargetDirectory.insert(0,strTemp);
		cstrFolderStructure.insert(cstrFolderStructure.begin(),strTemp);
		hSelectedItem=roTreeControl.GetParentItem(hSelectedItem);
	}
	strTargetDirectory.insert(0,m_strBaseDirectory);

	hTargetItemFolder=m_poAnimActionViewer->GetTreeItemFromDirectoryQueue(cstrFolderStructure);

	nTotalNumberOfSelectedItems=m_chSelectedItems.size();
	for (nCurrentSelectedItem=0;nCurrentSelectedItem<nTotalNumberOfSelectedItems;++nCurrentSelectedItem)
	{
		hSourceItem=m_chSelectedItems[nCurrentSelectedItem];
		piSelectedAnimAction=(IAnimActionClass*)m_poAnimActionViewer->GetItemData(hSourceItem);
		roAnimActionManager.GetAnimActionFilename(piSelectedAnimAction,strSourceFilePath);
		strTempSourceFilePath=strSourceFilePath;
		if (CFileUtil::MoveFile(strTempSourceFilePath,(CString)strTargetDirectory.c_str(),true)!=CFileUtil::ETREECOPYOK)
		{
			m_poAnimActionViewer->ReloadItems();
		}
		else
		{
			if (!m_poAnimActionViewer->MovePrototype(*m_poAnimActionViewer,hSourceItem,hTargetItemFolder))
			{
				m_poAnimActionViewer->ReloadItems();
			}
		}
	}

	m_chSelectedItems.clear();
}
//////////////////////////////////////////////////////////////////////////
